//: ## ![3DaysOfSwift.com Logo](PageHeader.png) ✅ Swift Study Guide
//: ### Study These Language Features
//: ©️ copyright of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) | [3 Days of Swift Bootcamp](https://www.3DaysOfSwift.com/bootcamp) | [Interview Prep](https://www.3DaysOfSwift.com/interview-prep)
//:
//: -------------------
//:
//: ## ✅ Value & Reference Types
//:
//: Classes (and closures) are reference types.
//:
//: Structs are value types.
//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:


// → reference type
class Superman {
    var superheroPoints = 50
}

// → value type
struct Superwoman {
    var superheroPoints = 50
}




//:
//: -------------------
//:
//: ## Value Types
//:
//: Each value type instantiates values copied each time they are stored in a new variable.
//:
//: -------------------
//:


// structures are value types
var superwoman1 = Superwoman()
var superwoman2 = superwoman1
var superwoman3 = superwoman1

// change some values
superwoman1.superheroPoints = 100
superwoman2.superheroPoints = 200
superwoman3.superheroPoints = 300

// what happened?
print(superwoman1.superheroPoints)
print(superwoman2.superheroPoints)
print(superwoman3.superheroPoints)


//:
//: -------------------
//:
//: ## Reference Types
//:
//: Each reference type instantiates objects that use the ARC counter system.
//:
//: -------------------
//:


// classes are reference types
var superman1 = Superman()
var superman2 = superman1
var superman3 = superman1

// change some values
superman1.superheroPoints = 100
superman2.superheroPoints = 200
superman3.superheroPoints = 300

// what happened?
print(superman1.superheroPoints)
print(superman2.superheroPoints)
print(superman3.superheroPoints)


//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:
//: ![3 Days Of Swift Logo](Footer.png) [Website](https://www.3DaysOfSwift.com) | [3 Days Of Swift Bootcamp](https://www.3DaysOfSwift.com/bootcamp) | [Interview Prep](https://www.3DaysOfSwift.com/interview-prep)
//:
//: © Copyright of [3DaysOfSwift.com](https://www.3DaysOfSwift.com). All rights reserved. Don't forget - come back when you've got an [interview](https://www.3DaysOfSwift.com/interview-prep)!
//:
//: Welcome to our community of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) developers!
//:
//: 🧕🏻🙋🏽‍♂️👨🏿‍💼👩🏼‍💼👩🏻‍💻💁🏼‍♀️👨🏼‍💼🙋🏻‍♂️🙋🏻‍♀️👩🏼‍💻🙋🏿💁🏽‍♂️🙋🏽‍♀️🙋🏿‍♀️🧕🏾🙋🏼‍♂️
//:
